<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.6
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2025 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */

# general
$lang['server_time'] = 'Server Time';
$lang['user_time'] = 'Your Time';
$lang['switch_lang'] = 'Switch Language';
$lang['event_schedule'] = 'Events Schedule';
$lang['event_schedule_start'] = 'Starts In';

# menu and navbar
$lang['menu_txt_1'] = 'Home';
$lang['menu_txt_2'] = 'Forum';
$lang['menu_txt_3'] = 'Register';
$lang['menu_txt_4'] = 'Log In';
$lang['menu_txt_5'] = 'My Account';
$lang['menu_txt_6'] = 'Log Out';
$lang['menu_txt_7'] = 'Downloads';
$lang['menu_txt_8'] = 'Buy Credits';
$lang['menu_txt_9'] = 'Vote & Reward';
$lang['menu_txt_10'] = 'Rankings';
$lang['menu_txt_11'] = 'Info';

# module titles
$lang['module_titles_txt_1'] = 'Register a New Account';
$lang['module_titles_txt_2'] = 'Account Login';
$lang['module_titles_txt_3'] = 'User CP';
$lang['module_titles_txt_4'] = 'My Account';
$lang['module_titles_txt_5'] = 'Change Email';
$lang['module_titles_txt_6'] = 'Change Password';
$lang['module_titles_txt_7'] = 'Vote for Credits';
$lang['module_titles_txt_8'] = 'Downloads';
$lang['module_titles_txt_9'] = 'Terms of Service';
$lang['module_titles_txt_10'] = 'Top Rankings';
$lang['module_titles_txt_11'] = 'Buy Credits';
$lang['module_titles_txt_12'] = 'Reset Character';
$lang['module_titles_txt_13'] = 'Clear PK';
$lang['module_titles_txt_14'] = 'Frequently Asked Questions';
$lang['module_titles_txt_15'] = 'Forgot Password';
$lang['module_titles_txt_16'] = 'Unstuck Character';
$lang['module_titles_txt_17'] = 'Server Information';
$lang['module_titles_txt_18'] = 'Reset Stats';
$lang['module_titles_txt_19'] = 'Clear Skill-Tree';
$lang['module_titles_txt_20'] = 'Email Verification';
$lang['module_titles_txt_21'] = 'Buy credits with PayPal';
$lang['module_titles_txt_22'] = 'Super Rewards';
$lang['module_titles_txt_23'] = 'Western Union';
$lang['module_titles_txt_24'] = 'Privacy Policy';
$lang['module_titles_txt_25'] = 'Add Stats';
$lang['module_titles_txt_26'] = 'Contact Us';
$lang['module_titles_txt_27'] = 'Refund Policy';
$lang['module_titles_txt_28'] = 'Buy Zen';
$lang['module_titles_txt_29'] = 'Castle Siege';

# usercp
$lang['usercp_menu_title'] = 'User Control Panel';
$lang['usercp_menu_txt_1'] = 'My Account';
$lang['usercp_menu_txt_2'] = 'Reset Character';
$lang['usercp_menu_txt_3'] = 'Clear PK';
$lang['usercp_menu_txt_4'] = 'Vote for Credits';
$lang['usercp_menu_txt_5'] = 'Buy Credits';
$lang['usercp_menu_txt_6'] = 'Unstuck Character';
$lang['usercp_menu_txt_7'] = 'V.I.P. Subscription';
$lang['usercp_menu_txt_8'] = 'Reset Stats';
$lang['usercp_menu_txt_9'] = 'Clear Skill-Tree';
$lang['usercp_menu_txt_10'] = 'Add Stats';
$lang['usercp_menu_txt_11'] = 'Buy Zen';

# success
$lang['success_1'] = 'Your account has been successfully created. You will be redirected to the Sign In form in 3 seconds.';
$lang['success_2'] = 'Your account password has been successfully updated.';
$lang['success_3'] = 'We have sent you an email address with a verification link. Once you verify your email address your password will be updated.';
$lang['success_4'] = 'We have sent you an email address with your new password! (remember to also check your spam/junk folder)';
$lang['success_5'] = 'Your account password has been successfully changed!';
$lang['success_6'] = 'We have sent you an email with a special link to recover your account access. (remember to also check your spam/junk folder)';
$lang['success_7'] = 'We have sent you an email address with your new password! (remember to also check your spam/junk folder)';
$lang['success_8'] = 'Your character has been successfully reset.';
$lang['success_9'] = 'Your character\'s stats have been successfully reset.';
$lang['success_10'] = 'Your character\'s PK level has been successfully reset.';
$lang['success_11'] = 'Your character been successfully moved to Lorencia\'s Bar.';
$lang['success_12'] = 'Your character\'s master skill tree been successfully cleared.';
$lang['success_13'] = '';
$lang['success_14'] = '';
$lang['success_15'] = 'News successfully added!';
$lang['success_16'] = '';
$lang['success_17'] = 'Your character\'s level up points have been successfully added.';
$lang['success_18'] = 'A verification link has been sent to your email to complete the registration.';
$lang['success_19'] = 'Please check your current email address to proceed.';
$lang['success_20'] = 'Your account\'s email address has been successfully changed.';
$lang['success_21'] = 'Zen purchase successfully completed.';
$lang['success_22'] = 'Thank you for contacting us, we will respond to your message shortly.';

# errors
$lang['error_1'] = 'The password you provided it\'s not correct, please try again.';
$lang['error_2'] = 'The username you entered does not exist.';
$lang['error_3'] = 'You have reached the maximum number of login failures, therefore your account has been temporarily disabled to login to the website.';
$lang['error_4'] = 'You must complete all the fields in the form.';
$lang['error_5'] = 'The username length must be 4 to 10 characters.';
$lang['error_6'] = 'The username can only contain alpha-numeric characters.';
$lang['error_7'] = 'The password length can be 4 to 32 characters.';
$lang['error_8'] = 'The passwords did not match.';
$lang['error_9'] = 'The email address you entered it\'s not valid.';
$lang['error_10'] = 'The username you entered already exists.';
$lang['error_11'] = 'The email address you entered already exists.';
$lang['error_12'] = 'Your account\'s information could not be retrieved. Please try again later.';
$lang['error_13'] = 'Your password is incorrect.';
$lang['error_14'] = 'Your account is online, please disconnect.';
$lang['error_15'] = 'Your account already voted for this TopSite in the last 12 hours.';
$lang['error_16'] = 'Your IP Address already voted for this TopSite in the last 12 hours.';
$lang['error_17'] = 'New registrations are not currently enabled, please try again later.';
$lang['error_18'] = 'Recaptcha verification failed, please try again.';
$lang['error_19'] = 'You have an active password change request, please check your email.';
$lang['error_20'] = 'We could not send you the verification email, please contact the support team.';
$lang['error_21'] = 'Your request could not be processed, please contact the support team.';
$lang['error_22'] = 'We could not create your account, please contact the support team.';
$lang['error_23'] = 'There has been an unexpected error, please contact the support team.';
$lang['error_24'] = 'The information provided in your request is not valid.';
$lang['error_25'] = 'Your request could not be completed, please try again.';
$lang['error_26'] = 'Your password change request expired, please request a new one.';
$lang['error_27'] = 'The authorization code provided is not valid.';
$lang['error_28'] = 'Your account is online, please disconnect.';
$lang['error_29'] = 'Your password could not be changed, please contact the support team.';
$lang['error_30'] = 'No accounts found with the provided email address.';
$lang['error_31'] = 'Invalid password recovery data.';
$lang['error_32'] = 'You do not have permission to reset this character.';
$lang['error_33'] = 'Your character does not meet the reset level requirement, please level up.';
$lang['error_34'] = 'You do not have enough zen.';
$lang['error_35'] = 'You do not have permission to reset this character\'s stats.';
$lang['error_36'] = 'You do not have permission to reset this character\'s PK level.';
$lang['error_37'] = 'You do not have permission to unstick this character\'s position.';
$lang['error_38'] = 'You do not have permission to clear this character\'s skill tree.';
$lang['error_39'] = 'Your master level must be ';
$lang['error_40'] = 'You do not have enough credits.';
$lang['error_41'] = 'Please complete all fields.';
$lang['error_42'] = 'Title can have a minimum of 4 characters and maximum of 80.';
$lang['error_43'] = 'The news content must be at least 4 characters long.';
$lang['error_44'] = 'Could not load requested rankings.';
$lang['error_45'] = 'Invalid Operation, redirecting to home.';
$lang['error_46'] = 'Your account has no characters.';
$lang['error_47'] = 'This module is not currently enabled, please try again later.';
$lang['error_48'] = 'Your request could not be processed because the email system is not active, please contact the support team.';
$lang['error_49'] = 'The provided cron id is not valid.';
$lang['error_50'] = 'The provided cron file does not exist.';
$lang['error_51'] = 'You have exceeded the amount of available level up points to add.';
$lang['error_52'] = 'Command stat can only be added to the Dark Lord class.';
$lang['error_53'] = 'Your stats may not exceed the %s points limit.';
$lang['error_54'] = 'You must add at least %s level up points.';
$lang['error_55'] = 'Buying the selected amount will exceed the zen limit allowed per character, please choose a different amount.';
$lang['error_56'] = 'The name entered is not valid.';
$lang['error_57'] = 'The message entered is not valid.';
$lang['error_58'] = 'There are no ranking results to display.';
$lang['error_59'] = 'Could not determine which classes require CMD stat. Please condifure character_cmd in your custom file.';
$lang['error_60'] = 'Could not load recaptcha library, please contact support.';
$lang['error_61'] = 'No news articles have been published.';
$lang['error_62'] = 'The language switching system is disabled.';
$lang['error_63'] = 'The selected language is not valid.';
$lang['error_64'] = 'You do not have permission to add stats to this character.';
$lang['error_65'] = 'Could not switch language.';
$lang['error_66'] = 'You have not set a configuration id.';
$lang['error_67'] = 'The userid entered is not valid.';
$lang['error_68'] = 'The username entered contains non-allowed characters.';
$lang['error_69'] = 'The username entered is not valid.';
$lang['error_70'] = 'The email entered is not valid.';
$lang['error_71'] = 'The character name entered is not valid.';
$lang['error_72'] = 'The amount of credits to add must be an unsigned number.';
$lang['error_73'] = 'The user identifier has not been set.';
$lang['error_74'] = 'There was an error adding the credits';
$lang['error_75'] = 'The amount of credits to subtract must be an unsigned number.';
$lang['error_76'] = 'There was an error subtracting the credits';
$lang['error_77'] = 'The provided configuration id is not valid.';
$lang['error_78'] = 'The title can only contain alphanumeric characters and spaces.';
$lang['error_79'] = 'The database entered contains non-allowed characters.';
$lang['error_80'] = 'The table entered contains non-allowed characters.';
$lang['error_81'] = 'The credits column entered contains non-allowed characters.';
$lang['error_82'] = 'The user column entered contains non-allowed characters.';
$lang['error_83'] = 'The user column identifier is not valid.';
$lang['error_84'] = 'Please fill all the required fields.';
$lang['error_85'] = 'There has been an error adding the configuration to the database, check for database errors.';
$lang['error_86'] = 'There has been an error editing the configuration, check for database errors.';
$lang['error_87'] = 'There has been an error deleting the configuration, check for database errors.';
$lang['error_88'] = 'Identifier not set, cannot check online status.';
$lang['error_89'] = 'There was an error getting the credits value.';
$lang['error_90'] = 'Could not load email configurations.';
$lang['error_91'] = 'Could not load email template.';
$lang['error_92'] = 'Email address invalid, cannot send email.';
$lang['error_93'] = 'You did not set a template.';
$lang['error_94'] = 'Could not load custom email template (you must provide a full path to the template).';
$lang['error_95'] = 'Email template has not been set.';
$lang['error_96'] = 'No recipient email address has been set.';
$lang['error_97'] = 'Email subject has not been set.';
$lang['error_98'] = 'Login configurations missing.';
$lang['error_99'] = 'There was an error while editing the news.';
$lang['error_100'] = 'Could not load vote system configurations.';
$lang['error_101'] = 'IP Address is not valid.';
$lang['error_102'] = 'Credit configuration has not been set (voting system).';
$lang['error_103'] = 'Castle siege data could not be loaded, please contact support.';
$lang['error_104'] = 'There are no cron jobs in the database.';
$lang['error_105'] = 'The requested action is not valid.';
$lang['error_106'] = 'The new cron could not be added, please fill all the required information.';
$lang['error_107'] = 'Another cron with the same file already exists.';
$lang['error_108'] = 'Could not load characters class data, please contact support.';
$lang['error_109'] = 'Your character class is not valid, please contact support.';
$lang['error_110'] = 'Could not load character class base stats, please contact support.';
$lang['error_111'] = 'The provided user id is not valid.';
$lang['error_112'] = 'The provided username is not valid.';
$lang['error_113'] = 'You do not have enough %s to reset your character stats.';
$lang['error_114'] = 'You do not have enough %s to unstick your character.';
$lang['error_115'] = 'Your character is already at Lorencia Bar.';
$lang['error_116'] = 'You do not have enough %s to clear your character pk status.';
$lang['error_117'] = 'Your character does not have a PK status.';
$lang['error_118'] = 'You do not have enough %s to clear your character\'s skill tree.';
$lang['error_119'] = 'Could not load your character\'s master level information, please contact support.';
$lang['error_120'] = 'Your character does not meet the level requirement to clear its skill tree.';
$lang['error_121'] = 'Your character does not meet the master level requirement to clear its skill tree.';
$lang['error_122'] = 'One or more entered values are not valid, please try again.';
$lang['error_123'] = 'Your character does not meet the level requirement to add stats.';
$lang['error_124'] = 'Your character does not meet the master level requirement to add stats.';
$lang['error_125'] = 'You do not have enough %s to add stats to your character.';
$lang['error_126'] = 'You do not have enough %s to reset your character.';
$lang['error_127'] = 'You have reached the maximum number of resets with this character.';
$lang['error_128'] = 'Missing character class group, please contact support.';

# registration
$lang['register_txt_1'] = 'Username:';
$lang['register_txt_2'] = 'Password:';
$lang['register_txt_3'] = 'Confirm Password:';
$lang['register_txt_4'] = 'Email Address:';
$lang['register_txt_5'] = 'Create Account';
$lang['register_txt_6'] = '%s to %s aplha-numeric characters long';
$lang['register_txt_7'] = '%s to %s characters long';
$lang['register_txt_8'] = 're-type your password';
$lang['register_txt_9'] = 'please use a valid email address';
$lang['register_txt_10'] = 'By registering you agree to our <br><a href="%s" target="_blank">Terms of Service</a>.';

# login
$lang['login_txt_1'] = 'Username:';
$lang['login_txt_2'] = 'Password:';
$lang['login_txt_3'] = 'Sign In';
$lang['login_txt_4'] = 'forgot your password?';
$lang['login_txt_5'] = 'You have used %s out of %s login attempts. After all %s have been used, you will be unable to login for 15 minutes.';
$lang['login_txt_6'] = 'Log Out';

# account
$lang['myaccount_txt_1'] = 'Account Status:';
$lang['myaccount_txt_2'] = 'Username:';
$lang['myaccount_txt_3'] = 'Email Address:';
$lang['myaccount_txt_4'] = 'Password:';
$lang['myaccount_txt_5'] = 'Online Status:';
$lang['myaccount_txt_6'] = 'change';
$lang['myaccount_txt_7'] = 'Active';
$lang['myaccount_txt_8'] = 'Frozen';
$lang['myaccount_txt_9'] = 'Online';
$lang['myaccount_txt_10'] = 'Offline';
$lang['myaccount_txt_12'] = 'Credits:';
$lang['myaccount_txt_13'] = 'Date';
$lang['myaccount_txt_14'] = 'recover';
$lang['myaccount_txt_15'] = 'My Characters:';
$lang['myaccount_txt_16'] = 'Connection History';
$lang['myaccount_txt_17'] = 'Server';
$lang['myaccount_txt_18'] = 'IP';
$lang['myaccount_txt_19'] = 'Action';

# voting
$lang['vfc_txt_1'] = 'TopSite';
$lang['vfc_txt_2'] = 'Credits Reward';
$lang['vfc_txt_3'] = 'Vote Now!';

# forgot password
$lang['forgotpass_txt_1'] = 'Email Address:';
$lang['forgotpass_txt_2'] = 'Send recovery email';

# downloads
$lang['downloads_txt_1'] = 'File';
$lang['downloads_txt_2'] = 'Host';
$lang['downloads_txt_3'] = 'File Size';
$lang['downloads_txt_4'] = 'MB';
$lang['downloads_txt_5'] = 'Download';
$lang['downloads_txt_6'] = 'Client Downloads';
$lang['downloads_txt_7'] = 'Patch Downloads';
$lang['downloads_txt_8'] = 'Tool Downloads';

# news
$lang['news_txt_1'] = 'Published by %s, %s';
$lang['news_txt_2'] = 'show comments';
$lang['news_txt_3'] = 'Read More &rsaquo;';
$lang['news_txt_4'] = 'Latest News';
$lang['news_txt_5'] = 'More';
$lang['news_txt_6'] = 'Notice';

# rankings
$lang['rankings_txt_1'] = 'Top Level';
$lang['rankings_txt_2'] = 'Top Resets';
$lang['rankings_txt_3'] = 'Top Killers';
$lang['rankings_txt_4'] = 'Top Guilds';
$lang['rankings_txt_5'] = 'Top Grand Resets';
$lang['rankings_txt_6'] = 'Top Online';
$lang['rankings_txt_7'] = 'Top Votes';
$lang['rankings_txt_8'] = 'Top Gens';
$lang['rankings_txt_9'] = '';
$lang['rankings_txt_10'] = 'Character';
$lang['rankings_txt_11'] = 'Class';
$lang['rankings_txt_12'] = 'Level';
$lang['rankings_txt_13'] = 'Resets';
$lang['rankings_txt_14'] = 'Kills';
$lang['rankings_txt_15'] = 'Total Online Time';
$lang['rankings_txt_16'] = 'Hours';
$lang['rankings_txt_17'] = 'Guild Name';
$lang['rankings_txt_18'] = 'Guild Master';
$lang['rankings_txt_19'] = 'Score';
$lang['rankings_txt_20'] = 'Last Updated @';
$lang['rankings_txt_21'] = 'Grand Resets';
$lang['rankings_txt_22'] = 'Top Master Level';
$lang['rankings_txt_23'] = 'Master Level';
$lang['rankings_txt_24'] = '';
$lang['rankings_txt_25'] = '';
$lang['rankings_txt_26'] = 'Gens Duprian';
$lang['rankings_txt_27'] = 'Gens Vanert';
$lang['rankings_txt_28'] = 'Guild Logo';
$lang['rankings_txt_29'] = 'Type';
$lang['rankings_txt_30'] = 'Rank';
$lang['rankings_txt_31'] = 'Contribution';
$lang['rankings_txt_32'] = 'Votes';
$lang['rankings_txt_33'] = 'Country';
$lang['rankings_txt_34'] = 'Location';
$lang['rankings_txt_35'] = 'Pk Level';

# rankings class filter
$lang['rankings_filter_1'] = 'All';
$lang['rankings_filter_2'] = 'Wizards';
$lang['rankings_filter_3'] = 'Knights';
$lang['rankings_filter_4'] = 'Elves';
$lang['rankings_filter_5'] = 'Gladiators';
$lang['rankings_filter_6'] = 'Lords';
$lang['rankings_filter_7'] = 'Summoners';
$lang['rankings_filter_8'] = 'Fighters';
$lang['rankings_filter_9'] = 'Lancers';
$lang['rankings_filter_10'] = 'Rune Wizards';
$lang['rankings_filter_11'] = 'Slayers';
$lang['rankings_filter_12'] = 'Gun Crushers';
$lang['rankings_filter_13'] = 'Light Wizards';
$lang['rankings_filter_14'] = 'Lemuria Mages';
$lang['rankings_filter_15'] = 'Illusion Knights';
$lang['rankings_filter_16'] = 'Alchemists';

# clear pk
$lang['clearpk_txt_1'] = 'Character';
$lang['clearpk_txt_2'] = 'Zen';
$lang['clearpk_txt_3'] = 'PK Status';
$lang['clearpk_txt_4'] = 'Clear PK';
$lang['clearpk_txt_5'] = 'Your character must have at least %s zen to clear pk';

# clear skill tree
$lang['clearst_txt_1'] = 'Character';
$lang['clearst_txt_2'] = 'Master Level';
$lang['clearst_txt_3'] = 'Zen';
$lang['clearst_txt_4'] = 'GO';
$lang['clearst_txt_5'] = 'Points';
$lang['clearst_txt_6'] = 'Your character must be at least master level %s';
$lang['clearst_txt_7'] = 'Your character must have at least %s zen to reset the skill tree';
$lang['clearst_txt_8'] = 'Your character must be at least level %s';

# donation
$lang['donation_txt_2'] = 'Credits';

# change password
$lang['changepassword_txt_1'] = 'Current Password:';
$lang['changepassword_txt_2'] = 'New Password:';
$lang['changepassword_txt_3'] = 'Confirm New Password:';
$lang['changepassword_txt_4'] = 'Change Password';

# reset
$lang['resetcharacter_txt_1'] = 'Character';
$lang['resetcharacter_txt_2'] = 'Level';
$lang['resetcharacter_txt_3'] = 'Zen';
$lang['resetcharacter_txt_4'] = 'Resets';
$lang['resetcharacter_txt_5'] = 'Reset';
$lang['resetcharacter_txt_6'] = 'Your character must be level %s';
$lang['resetcharacter_txt_7'] = 'Your character must have at least %s zen';
$lang['resetcharacter_txt_8'] = 'You will be rewarded with %s credits';
$lang['resetcharacter_txt_9'] = 'You must have at least %s credits to reset your character';
$lang['resetcharacter_txt_10'] = 'You can reset a maximum of %s times';
$lang['resetcharacter_txt_11'] = 'Your character\'s inventory will be cleared, make sure to place all equipment in your vault.';

# reset stats
$lang['resetstats_txt_1'] = 'Character';
$lang['resetstats_txt_2'] = 'Level';
$lang['resetstats_txt_3'] = 'STR';
$lang['resetstats_txt_4'] = 'AGI';
$lang['resetstats_txt_5'] = 'VIT';
$lang['resetstats_txt_6'] = 'ENE';
$lang['resetstats_txt_7'] = 'CMD';
$lang['resetstats_txt_8'] = 'Reset';
$lang['resetstats_txt_9'] = 'Your character must have at least %s zen to reset stats';

# unstick
$lang['unstickcharacter_txt_1'] = 'Character';
$lang['unstickcharacter_txt_2'] = 'Zen';
$lang['unstickcharacter_txt_3'] = 'Unstick';
$lang['unstickcharacter_txt_4'] = 'Your character must have at least %s zen to unstick';

# add stats
$lang['addstats_txt_1'] = 'Character';
$lang['addstats_txt_2'] = '<strong>%s</strong> points available';
$lang['addstats_txt_3'] = 'Strength';
$lang['addstats_txt_4'] = 'Agility';
$lang['addstats_txt_5'] = 'Vitality';
$lang['addstats_txt_6'] = 'Energy';
$lang['addstats_txt_7'] = 'Command';
$lang['addstats_txt_8'] = 'Add Points';
$lang['addstats_txt_9'] = 'Your character must have at least %s zen to add stats';
$lang['addstats_txt_10'] = 'Your character must be at least master level %s';
$lang['addstats_txt_11'] = 'Your character must be at least level %s';
$lang['addstats_txt_12'] = 'Each stat can have a maximum of %s points';
$lang['addstats_txt_13'] = 'You must add at least %s level up points to use this feature';

# castle siege banner
$lang['csbanner_txt_1'] = 'Castle Owner'; // to be removed
$lang['csbanner_txt_2'] = 'Battle Begins In'; // to be removed
$lang['csbanner_txt_3'] = 'Guild Master'; // to be removed

# profiles
$lang['profiles_txt_1'] = 'Guild Profile';
$lang['profiles_txt_2'] = 'Player Profile';
$lang['profiles_txt_3'] = 'Guild Master:';
$lang['profiles_txt_4'] = 'Score:';
$lang['profiles_txt_5'] = 'Members:';
$lang['profiles_txt_6'] = 'Members';
$lang['profiles_txt_7'] = 'Level';
$lang['profiles_txt_8'] = 'Resets';
$lang['profiles_txt_9'] = 'Grand Resets';
$lang['profiles_txt_10'] = 'Strength';
$lang['profiles_txt_11'] = 'Agility';
$lang['profiles_txt_12'] = 'Vitality';
$lang['profiles_txt_13'] = 'Energy';
$lang['profiles_txt_14'] = 'Command';
$lang['profiles_txt_15'] = 'Kills';
$lang['profiles_txt_16'] = 'Guild';
$lang['profiles_txt_17'] = 'Status';
$lang['profiles_txt_18'] = 'Online';
$lang['profiles_txt_19'] = 'Offline';
$lang['profiles_txt_20'] = 'Master Level';

# change email address
$lang['changemail_txt_1'] = 'New Email';
$lang['changemail_txt_2'] = 'Change';

# sidebar server info
$lang['sidebar_srvinfo_txt_1'] = 'Server Info';
$lang['sidebar_srvinfo_txt_2'] = 'Total Accounts';
$lang['sidebar_srvinfo_txt_3'] = 'Total Characters';
$lang['sidebar_srvinfo_txt_4'] = 'Total Guilds';
$lang['sidebar_srvinfo_txt_5'] = 'Online Users';
$lang['sidebar_srvinfo_txt_6'] = 'Version';
$lang['sidebar_srvinfo_txt_7'] = 'Experience';
$lang['sidebar_srvinfo_txt_8'] = 'Master Experience';
$lang['sidebar_srvinfo_txt_9'] = 'Drop';

# castle siege
$lang['castlesiege_txt_1'] = 'Castle Siege Battle';
$lang['castlesiege_txt_2'] = 'Castle Owner';
$lang['castlesiege_txt_3'] = 'Trial Money:';
$lang['castlesiege_txt_4'] = 'Tax Rate Goblin:';
$lang['castlesiege_txt_5'] = 'Tax Rate NPC:';
$lang['castlesiege_txt_6'] = 'Tax Rate Trial:';
$lang['castlesiege_txt_7'] = 'Castle Information';
$lang['castlesiege_txt_8'] = 'Zen';
$lang['castlesiege_txt_9'] = 'Current Stage:';
$lang['castlesiege_txt_10'] = 'Next Stage:';
$lang['castlesiege_txt_11'] = 'Battle Duration:';
$lang['castlesiege_txt_12'] = 'Guild Master';
$lang['castlesiege_txt_13'] = 'Castle Owner Alliance';
$lang['castlesiege_txt_14'] = 'Guild';
$lang['castlesiege_txt_15'] = 'Master';
$lang['castlesiege_txt_16'] = 'Logo';
$lang['castlesiege_txt_17'] = 'Score';
$lang['castlesiege_txt_18'] = 'Members';
$lang['castlesiege_txt_19'] = 'Registered Guilds';
$lang['castlesiege_txt_20'] = 'Event Schedule';
$lang['castlesiege_txt_21'] = 'Stage';
$lang['castlesiege_txt_22'] = 'Start Date';
$lang['castlesiege_txt_23'] = 'End Date';
$lang['castlesiege_schedule_1'] = 'Guild Registration Period';
$lang['castlesiege_schedule_2'] = 'Registration period for Mark of Lord';
$lang['castlesiege_schedule_3'] = 'Announcement';
$lang['castlesiege_schedule_4'] = 'Castle Preparation';
$lang['castlesiege_schedule_5'] = 'Siege Warfare';
$lang['castlesiege_schedule_6'] = 'Idle';
$lang['castlesiege_time_1'] = '%s days %s hours';
$lang['castlesiege_time_2'] = '%s hours %s minutes';
$lang['castlesiege_time_3'] = '%s minutes';
$lang['castlesiege_time_4'] = 'Less than one minute.';
$lang['castlesiege_battle_duration'] = '%s hours %s minutes';
$lang['castlesiege_widget_title'] = 'Castle Siege';

# buy zen
$lang['buyzen_txt_1'] = 'Buy Zen';
$lang['buyzen_txt_2'] = ' zen sent to ';
$lang['buyzen_txt_3'] = 'Character';
$lang['buyzen_txt_4'] = 'Zen';
$lang['buyzen_txt_5'] = 'Buy';
$lang['buyzen_txt_6'] = 'credit(s)';

# contact us
$lang['contactus_txt_1'] = 'Email Address';
$lang['contactus_txt_2'] = 'Message';
$lang['contactus_txt_3'] = 'Send';

# footer
$lang['footer_terms'] = 'Terms of Service';
$lang['footer_privacy'] = 'Privacy Policy';
$lang['footer_refund'] = 'Refund Policy';
$lang['footer_info'] = 'Server Information';
$lang['footer_contact'] = 'Contact Us';
$lang['footer_copyright'] = '%s &copy; %s, ALL RIGHTS RESERVED.';
$lang['footer_webzen_copyright'] = 'This site is in no way associated with or endorsed by Webzen Inc.';