<?php
// Ruta del archivo de bloqueo
$lockFile = 'script.lock';

// Verificar si el archivo de bloqueo existe
if (file_exists($lockFile)) {
    die("El script ya ha sido ejecutado una vez y no puede ejecutarse de nuevo.");
}

// Crear el archivo de bloqueo
file_put_contents($lockFile, "Este script ya ha sido ejecutado.");

// Leer el archivo JSON
$config = json_decode(file_get_contents('includes/config/webengine.json'), true);

// Configuración de la conexión
$host = $config['SQL_DB_HOST'];
$dbname = $config['SQL_DB_NAME'];
$user = $config['SQL_DB_USER'];
$pass = $config['SQL_DB_PASS'];
$port = $config['SQL_DB_PORT'];

try {
    // Crear una nueva conexión PDO
    $pdo = new PDO("dblib:host=$host:$port;dbname=$dbname", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Consulta SQL para actualizar la columna cron_run_time
    $sql = "UPDATE WEBENGINE_CRON SET cron_run_time = :new_value";
    $stmt = $pdo->prepare($sql);

    // Ejecutar la consulta con el valor deseado
    $new_value = 300;
    $stmt->bindParam(':new_value', $new_value, PDO::PARAM_INT);
    $stmt->execute();

    echo "Actualización completada con éxito.";
} catch (PDOException $e) {
    echo "Error en la conexión o en la consulta: " . $e->getMessage();
}
?>
